/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.neiHandler;

import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.github.bartimaeusnek.bartworks.common.items.LabParts;
import com.github.bartimaeusnek.bartworks.common.tileentities.multis.GT_TileEntity_BioVat;
import com.github.bartimaeusnek.bartworks.neiHandler.NEI_BW_Config;
import cpw.mods.fml.common.event.FMLInterModComms;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.nei.GT_NEI_DefaultHandler;
import java.awt.Rectangle;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class BW_NEI_BioVatHandler
extends GT_NEI_DefaultHandler {
    public BW_NEI_BioVatHandler(GT_Recipe.GT_Recipe_Map aRecipeMap) {
        super(aRecipeMap);
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(65, 13, 36, 18), this.getOverlayIdentifier(), new Object[0]));
        if (!NEI_BW_Config.sIsAdded) {
            FMLInterModComms.sendRuntimeMessage((Object)GT_Values.GT, (String)"NEIPlugins", (String)"register-crafting-handler", (String)("gregtech@" + this.getRecipeName() + "@" + this.getOverlayIdentifier()));
            GuiCraftingRecipe.craftinghandlers.add(this);
            GuiUsageRecipe.usagehandlers.add(this);
        }
    }

    public TemplateRecipeHandler newInstance() {
        return new BW_NEI_BioVatHandler(this.mRecipeMap);
    }

    public void drawExtras(int aRecipeIndex) {
        block7: {
            String[] recipeDesc;
            block5: {
                int[] tSpecialA;
                int[] lines;
                block10: {
                    block9: {
                        block8: {
                            block6: {
                                int base = 70;
                                lines = new int[]{base, base + 8, base + 16, base + 24, base + 32, base + 40, base + 48, base + 56, base + 64};
                                int tEUt = ((GT_NEI_DefaultHandler.CachedDefaultRecipe)this.arecipes.get((int)aRecipeIndex)).mRecipe.mEUt;
                                int tDuration = ((GT_NEI_DefaultHandler.CachedDefaultRecipe)this.arecipes.get((int)aRecipeIndex)).mRecipe.mDuration;
                                recipeDesc = ((GT_NEI_DefaultHandler.CachedDefaultRecipe)this.arecipes.get((int)aRecipeIndex)).mRecipe.getNeiDesc();
                                if (recipeDesc != null) break block5;
                                if (tEUt != 0) {
                                    GT_NEI_DefaultHandler.drawText((int)10, (int)lines[0], (String)(this.trans("152", "Total: ") + (long)tDuration * (long)tEUt + " EU"), (int)-16777216);
                                    GT_NEI_DefaultHandler.drawText((int)10, (int)lines[1], (String)(this.trans("153", "Usage: ") + tEUt + " EU/t"), (int)-16777216);
                                    if (this.mRecipeMap.mShowVoltageAmperageInNEI) {
                                        GT_NEI_DefaultHandler.drawText((int)10, (int)lines[2], (String)(this.trans("154", "Voltage: ") + tEUt / this.mRecipeMap.mAmperage + " EU"), (int)-16777216);
                                        GT_NEI_DefaultHandler.drawText((int)10, (int)lines[3], (String)(this.trans("155", "Amperage: ") + this.mRecipeMap.mAmperage), (int)-16777216);
                                    } else {
                                        GT_NEI_DefaultHandler.drawText((int)10, (int)lines[2], (String)this.trans("156", "Voltage: unspecified"), (int)-16777216);
                                        GT_NEI_DefaultHandler.drawText((int)10, (int)lines[3], (String)this.trans("157", "Amperage: unspecified"), (int)-16777216);
                                    }
                                }
                                if (tDuration > 0) {
                                    GT_NEI_DefaultHandler.drawText((int)10, (int)lines[4], (String)(this.trans("158", "Time: ") + String.format("%.2f " + this.trans("161", " secs"), Float.valueOf(0.05f * (float)tDuration))), (int)-16777216);
                                }
                                int tSpecial = ((GT_NEI_DefaultHandler.CachedDefaultRecipe)this.arecipes.get((int)aRecipeIndex)).mRecipe.mSpecialValue;
                                tSpecialA = GT_TileEntity_BioVat.specialValueUnpack(tSpecial);
                                GT_NEI_DefaultHandler.drawText((int)10, (int)lines[5], (String)(StatCollector.func_74838_a((String)"nei.biovat.0.name") + " " + tSpecialA[0]), (int)-16777216);
                                if (tSpecialA[1] != -100 || !GT_Mod.gregtechproxy.mLowGravProcessing) break block6;
                                GT_NEI_DefaultHandler.drawText((int)10, (int)lines[7], (String)this.trans("159", "Needs Low Gravity"), (int)-16777216);
                                break block7;
                            }
                            if (tSpecialA[1] != -200 || !GT_Mod.gregtechproxy.mEnableCleanroom) break block8;
                            GT_NEI_DefaultHandler.drawText((int)10, (int)lines[7], (String)this.trans("160", "Needs Cleanroom"), (int)-16777216);
                            break block7;
                        }
                        if (tSpecialA[1] != -300 || !GT_Mod.gregtechproxy.mEnableCleanroom) break block9;
                        GT_NEI_DefaultHandler.drawText((int)10, (int)lines[7], (String)this.trans("160", "Needs Cleanroom & LowGrav"), (int)-16777216);
                        break block7;
                    }
                    if (tSpecialA[1] != -400) break block10;
                    GT_NEI_DefaultHandler.drawText((int)10, (int)lines[7], (String)this.trans("216", "Deprecated Recipe"), (int)-16777216);
                    break block7;
                }
                if (!GT_Utility.isStringValid((Object)this.mRecipeMap.mNEISpecialValuePre) && !GT_Utility.isStringValid((Object)this.mRecipeMap.mNEISpecialValuePost)) break block7;
                GT_NEI_DefaultHandler.drawText((int)10, (int)lines[6], (String)((tSpecialA[2] == 1 ? StatCollector.func_74838_a((String)"nei.biovat.1.name") : StatCollector.func_74838_a((String)"nei.biovat.2.name")) + this.mRecipeMap.mNEISpecialValuePre + tSpecialA[3] * this.mRecipeMap.mNEISpecialValueMultiplier + this.mRecipeMap.mNEISpecialValuePost), (int)-16777216);
                break block7;
            }
            int tSpecial = 0;
            for (String descLine : recipeDesc) {
                GT_NEI_DefaultHandler.drawText((int)10, (int)(73 + 10 * tSpecial), (String)descLine, (int)-16777216);
                ++tSpecial;
            }
        }
    }

    public void loadUsageRecipes(ItemStack aResult) {
        if (aResult != null && aResult.func_77973_b() instanceof LabParts && aResult.func_77960_j() < 3) {
            for (GT_Recipe recipe : this.getSortedRecipes()) {
                if (aResult.func_77978_p() == null || recipe == null || !(recipe.mSpecialItems instanceof ItemStack) || !(((ItemStack)recipe.mSpecialItems).func_77973_b() instanceof LabParts) || !aResult.func_77978_p().equals((Object)((ItemStack)recipe.mSpecialItems).func_77978_p())) continue;
                this.arecipes.add(new GT_NEI_DefaultHandler.CachedDefaultRecipe((GT_NEI_DefaultHandler)this, recipe));
            }
        } else {
            super.loadCraftingRecipes(aResult);
        }
    }

    public void loadCraftingRecipes(ItemStack aResult) {
        if (aResult == null || !(aResult.func_77973_b() instanceof LabParts) || aResult.func_77960_j() >= 3) {
            super.loadCraftingRecipes(aResult);
        }
    }
}

